DROP FUNCTION IF EXISTS fnGetCostoTotal;

DELIMITER $$
CREATE FUNCTION fnGetCostoTotal(p_idProducto INT, p_fechaCorte DATE) RETURNS DECIMAL(18,2)
BEGIN
    DECLARE costoTotal DECIMAL(18,2);    
    
    DECLARE nFilas int;
    DECLARE v_idProducto int;    
    DECLARE v_idDetaNota int;
    DECLARE v_fechaEmision datetime;
    DECLARE v_fechaContable datetime;
    
    -- DECLARE v_cantidadSalida decimal(18,2);
    DECLARE v_precioUnitarioSalida decimal(18,2);
    
    DECLARE v_cantidadEntrada decimal(18,2);
    DECLARE v_costoUnitarioEntrada decimal(18,2);
    DECLARE v_costoTotalEntrada decimal(18,2);
    
    DECLARE v_cantidadSalida decimal(18,2);
    DECLARE v_costoUnitarioSalida decimal(18,2);
    DECLARE v_costoTotalSalida decimal(18,2);
    
    DECLARE v_cantidadSaldo decimal(18,2);
    DECLARE v_costoUnitarioSaldo decimal(18,2);
    DECLARE v_costoTotalSaldo decimal(18,2);
    
    DECLARE nFilas2 int;
	DECLARE v_idDetaNota2 int;
    
    DECLARE v_tipoNota char(5);
    DECLARE v_contador int;
    
    DROP TEMPORARY TABLE IF EXISTS kardex_temp;
		DROP TEMPORARY TABLE IF EXISTS kardex_temp2;
		
		CREATE TEMPORARY TABLE kardex_temp AS (
		SELECT DNA.idDetaNota, DNA.idNotaAlmacen, DNA.idProducto, 	date(NA.fechaContable) as fechaContable,
				CASE WHEN NA.tipoNota = 'E' THEN NA.fechaContable ELSE '' END AS fecha,
				CASE WHEN NA.tipoNota = 'E' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaFormato,
				CASE WHEN NA.tipoNota = 'S' THEN NA.fechaContable ELSE '' END AS fechaUso,
				CASE WHEN NA.tipoNota = 'S' THEN DATE_FORMAT(NA.fechaContable, "%d/%m/%Y") ELSE '' END AS fechaUsoFormato,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.tipoDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN 'NA' 
					 WHEN NA.tipoNota = 'S' THEN 'NA'
                    ELSE '' 
                END AS tipoDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.serieDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN '001' 
					 WHEN NA.tipoNota = 'S'  THEN '001'
					 ELSE '' 
				END AS serieDocumento,
				CASE WHEN NA.tipoNota = 'E' and NA.tipoDocumento is not null THEN NA.numeroDocumento 
					 WHEN NA.tipoNota = 'E' and NA.tipoDocumento is null THEN NA.correlativo 
					 WHEN NA.tipoNota = 'S' THEN NA.correlativo
					 ELSE '' 
                END AS numeroDocumento,
				CASE WHEN NA.idDestino != 2 THEN M.descripcion
					ELSE ifnull(UM.placa, '') 
				END as placa,
				-- NA.tipoOperacion,
                CASE WHEN NA.tipoNota = 'E' THEN M2.descripcion
					 WHEN NA.tipoNota = 'S' THEN M3.descripcion 
				END as tipoOperacion,
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadEntrada',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioEntrada',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalEntrada',
				-- CASE WHEN NA.tipoNota = 'S' THEN sum(DNA.cantidadTotal) ELSE 0 END AS 'cantidadSalida', 
				CASE WHEN NA.tipoNota = 'S' THEN DNA.cantidadTotal ELSE 0 END AS 'cantidadSalida', 
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSalida',
                CASE WHEN NA.tipoNota = 'S' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSalida',
				CASE WHEN NA.tipoNota = 'E' THEN DNA.cantidadTotal ELSE '' END AS 'cantidadSaldo', 
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorUnitario ELSE '' END AS 'costoUnitarioSaldo',
                CASE WHEN NA.tipoNota = 'E' THEN DNA.valorVenta ELSE '' END AS 'costoTotalSaldo',
				NA.tipoNota, 0 as activo
		FROM DETALLE_NOTA_ALMACEN DNA
		INNER JOIN NOTA_ALMACEN NA ON NA.idNotaAlmacen = DNA.idNotaAlmacen and NA.estado = 'C'
        LEFT JOIN ORDEN_MANTENIMIENTO OM ON OM.idOrdenMantenimiento = NA.idOrdenMantenimiento 
        LEFT JOIN ORDEN_SERVICIO OS ON OS.idOrdenServicio = NA.idOrdenServicio
		LEFT JOIN UNIDAD_MOVIL UM ON UM.idUnidad = NA.idUnidad
		LEFT JOIN MULTITABLA M ON M.valor = NA.idDestino AND M.dep_id = 21
		LEFT JOIN MULTITABLA M2 ON M2.abrev = NA.tipoOperacion AND M2.dep_id = 18
		LEFT JOIN MULTITABLA M3 ON M3.abrev = NA.tipoOperacion AND M3.dep_id = 22
		WHERE DNA.idProducto = p_idProducto and cast(NA.fechaContable as date) <= p_fechaCorte
        -- GROUP BY DNA.idNotaAlmacen,  DNA.idProducto
		ORDER BY date(NA.fechaContable) asc, NA.tipoNota asc, DNA.idDetaNota asc  );
		        
        CREATE TEMPORARY TABLE kardex_temp2 AS (SELECT * FROM kardex_temp ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc);
		       
        
		SET @nFilas = (SELECT count(idDetaNota) FROM kardex_temp);
		
		IF @nFilas = null THEN
			SET @nFilas = 0;
		END IF;	
        
        SET @v_cantidadSaldo = 0;
        SET @v_costoUnitarioSaldo = 0;
        SET @v_costoTotalSaldo = 0;
    
		WHILE @nFilas > 0 DO
			(SELECT idDetaNota, fechaContable, 
				cantidadEntrada, costoUnitarioEntrada, costoTotalEntrada, 
				cantidadSalida, costoUnitarioSalida, costoTotalSalida, tipoNota
			INTO @v_idDetaNota, @v_fechaContable, 
				@v_cantidadEntrada, @v_costoUnitarioEntrada, @v_costoTotalEntrada,
                @v_cantidadSalida, @v_costoUnitarioSalida, @v_costoTotalSalida, @v_tipoNota
			FROM kardex_temp
			ORDER BY date(fechaContable) asc, tipoNota asc, idDetaNota asc limit 1);
            
            IF @v_tipoNota = 'E' THEN
                
                SET @v_cantidadSaldo = @v_cantidadSaldo + @v_cantidadEntrada;
                SET @v_costoTotalSaldo = @v_costoTotalSaldo + @v_costoTotalEntrada;
                SET @v_costoUnitarioSaldo = @v_costoTotalSaldo/@v_cantidadSaldo;                
                
				UPDATE kardex_temp2 
                SET cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
                
			ELSE                 
                SET @v_costoUnitarioSalida = @v_costoUnitarioSaldo;
                SET @v_costoTotalSalida = @v_cantidadSalida*@v_costoUnitarioSalida;
                SET @v_cantidadSaldo = @v_cantidadSaldo - @v_cantidadSalida;
                SET @v_costoTotalSaldo = @v_cantidadSaldo * @v_costoUnitarioSaldo;
                
				UPDATE kardex_temp2
                SET 
                    costoUnitarioSalida = cast( round(@v_costoUnitarioSalida, 2 ) as decimal(18,2)),
                    costoTotalSalida = cast( round(@v_costoTotalSalida, 2 ) as decimal(18,2)),
                    cantidadSaldo = cast( round(@v_cantidadSaldo, 2 ) as decimal(18,2)),
					costoUnitarioSaldo = cast( round(@v_costoUnitarioSaldo, 2) as decimal(18,2) ),
					costoTotalSaldo = cast( round(@v_costoTotalSaldo, 2) as decimal(18,2) )
                WHERE idDetaNota =@v_idDetaNota;
            END IF;
             
			DELETE FROM kardex_temp WHERE idDetaNota =@v_idDetaNota;
			SET @nFilas = @nFilas - 1;
		END WHILE;
        
        UPDATE kardex_temp2 
		SET activo = 1
		WHERE idDetaNota = @v_idDetaNota;
        
        SET @costoTotal = (        
			SELECT 
				(case when cantidadSaldo = 0 then 0
				else costoTotalSaldo end) as costoTotalSaldo
			FROM kardex_temp2 k WHERE activo = 1
			ORDER BY k.fechaContable DESC LIMIT 1);
    
    -- set @costoTotal = 55.5;
    RETURN @costoTotal;
END
$$